<?php
/************************************************************************
 The MyReview system for web-based conference management

 Copyright (C) 2003-2009 Philippe Rigaux
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation;

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/


require_once("Slot.php");
require_once("ShowSlot.php");
require_once("ConfSession.php");
require_once("RequiredFile.php");
require_once("Mail.php");
require_once("RegAuthor.php");
require_once("RegParticipant.php");
require_once("RegPage.php");
require_once("RegOther.php");
require_once("PaymentMode.php");
require_once("RegChoice.php");
require_once("ConferenceNames.php");
require_once("UserTopic.php");
require_once("PaperList.php");

function numtoword($num)
{
  switch ($num){
    case 0:
      $num = 'No';
      break;
    case 1:
      $num = 'One';
      break;
    case 2:
      $num = 'Two';
      break;
    case 3:
      $num = 'Three';
      break;
    case 4:
      $num = 'Four';
      break;
    case 5:
      $num = 'Five';
      break;
    case 6:
      $num = 'Six';
      break;
    case 7:
      $num = 'Seven';
      break;
    case 8:
      $num = 'Eight';
      break;
    case 9:
      $num = 'Nine';
      break;
    case 10:
      $num = 'Ten';
      break;
    default:
      $num = $num;
  }
  return $num;
}

/**
 * The index controller
 *
 * This controller is in charge of the following task (...)
 * @package    Index
 */

class IndexController extends Myreview_Controller_Action
{
  /**
   * The default action. It just displays the home page
   *
   */

  function indexAction()
  {
    $this->view->setFile ("content", "index.xml");
    echo $this->view->render("layout");
  }

  /**
   * Shows guidelines for authors
   */

  function guidelinesAction()
  {
    $loginSuccessful = $this->getRequest()->getParam("login_successful");
    if (!empty($loginSuccessful)) {
      $this->view->initial_message = $this->zmax_context->texts->welcome_connected_user;
    }
    else {
      $this->view->initial_message = "";
    }

    $this->view->setFile ("content", "guidelines.xml");
    echo $this->view->render("layout");
  }

  /**
   * Create an account
   * @author philipperigaux
   *
   */

  function createaccountAction()
  {
    $this->view->setFile ("content", "createaccount.xml");
    // Create a new user and propose the form
    $user  = new User();
    $userRow = $user->createRow();
    $userRow->addRole (User::AUTHOR_ROLE);
    $this->view->form_user =    $userRow->form($this->view);

    $this->view->form_mode = "insert";

    echo $this->view->render("layout");
  }


  /**
   * Add  an account
   */

  function addaccountAction()
  {

    $form_mode = $this->getRequest()->getParam("form_mode");
    $changePassword = $this->getRequest()->getParam("change_password");
    $register = $this->getRequest()->getParam("register");

    if (empty($form_mode)) {
      throw new  Zmax_Exception ("Invalid action request (User::addaccount)");
    }

    $user  = new User();

    // @todo Probably some filtering would be appropriate
    $data = array ("first_name" => $_POST['first_name'],
         "last_name" => $_POST['last_name'],
         "affiliation" => $_POST['affiliation'],
         "address" => $_POST['address'],
         "city" => $_POST['city'],
        "state" => $_POST['state'],
          "zip_code" => $_POST['zip_code'],
          "phone" => $_POST['phone'],
         "email" => $_POST['email'],
        "country_code" => $_POST['country_code'],
        "requirements" => $_POST['requirements'],
        "cv" => $_POST['cv'],
    "creation_date" => new Zend_Db_Expr('CURDATE()')
    );

    if ($changePassword) {
      $data["password"]  = $_POST['password'];
    }

    if  ($form_mode == "insert") {
      $userRow = $user->createRow();
      $currentPassword = "";
      $userRow->setFromArray($data);
      $messages = $userRow->checkInsert($this->zmax_context->texts);
    }
    else {
      $userRow = $this->user;
      $currentPassword = $userRow->password;
      $userRow->setFromArray($data);
      $messages = $userRow->checkUpdate($this->zmax_context->texts, $changePassword);
    }

    if (count($messages) > 0) {
      $this->view->setFile ("content", "error_account.xml");
      $this->view->setBlock ("content", "MESSAGE",  "MESSAGES");

      foreach ($messages as $message) {
        $this->view->message = $message;
        $this->view->SUCCESS = "";
        $this->view->append("MESSAGES", "MESSAGE");
      }
      //    print_r($messages);
      $this->view->form_mode = $form_mode;
      $this->view->form_user = $userRow->form($this->view, "form_user.xml",
      $changePassword, $register);
    }
    else {
      // OK, insert or update the new user
      if    ($form_mode == "insert") {
        if (!$register) {
          $this->view->content = $this->zmax_context->texts->author->confirm_account;
        }
        else {
          $this->view->content = $this->zmax_context->texts->author->confirm_registration;
        }
      }
      else {
        $userRow->putInView($this->view);
        $this->view->setFile("content", "confirm_update_account.xml");
        $this->view->setBlock("content", "INFO_REVIEWER");
        $this->view->setBlock("content", "INFO_ATTENDEE");
        if (!$userRow->isReviewer() ) {
          $this->view->INFO_REVIEWER = "";
        }
        if (!$userRow->isParticipant() ) {
          $this->view->INFO_PARTICIPANT = "";
        }

      }

      // Encrypt the password and save
      if ($changePassword) {
        $userRow->password = md5($userRow->password);
      }
      else {
        // Keep the current password
        $userRow->password = $currentPassword;
      }

      // Change the default role if this is a registration
      if ($register) {
        $userRow->setRole(User::PARTICIPANT_ROLE);
      }
      $userRow->save();
    }
    echo $this->view->render("layout");
  }

  /**
   * Update the password of a user
   */

  function changepasswordAction()
  {
    $this->view->setFile("content", "updatepassword.xml");
    $this->view->setFile("form_password", "form_password.xml");

    $formPassword = $this->getRequest()->getParam("form_password");

    if (empty($formPassword)) {
      throw new  Zmax_Exception ("Invalid action request (Author::updatepassword)");
    }

    // OK, there should be a user
    $userRow = $this->user;
    $userRow->password = $this->getRequest()->getParam("password");
    $message = $userRow->checkPassword($this->zmax_context->texts);

    if (!empty($message)) {
      $this->view->message = $message;
    }
    else {
      // OK, insert or update the new user
      $this->view->message = $this->zmax_context->texts->author->confirm_password_update;
      $this->view->form_password = "";
      $userRow->password = md5($userRow->password);

      $userRow->save();
    }
    echo $this->view->render("layout");
  }

  /**
   * Action that explains how a password can be recovered
   */

  function lostpasswordAction()
  {
    $this->view->setFile ("content", "lostpassword.xml");
    echo $this->view->render("layout");
  }


  /**
   * Edit an account
   */

  function editaccountAction()
  {
    // Check that the user is connected !
    if ($this->checkSession()) {
      // If the user comes from the login form: welcome message
      $loginSuccessful = $this->getRequest()->getParam("login_successful");
      if (!empty($loginSuccessful)) {
        $this->view->initial_message = $this->zmax_context->texts->welcome_connected_user;
      }
      else {
        $this->view->initial_message = "";
      }

      $this->view->setFile ("content", "editaccount.xml");
      $this->view->setFile ("form_password", "form_password.xml");

      $this->view->form_mode = "update";
      $this->view->form_user = $this->user->form($this->view, "form_user.xml", false);

      echo $this->view->render("layout");
    }
    else {
      $this->_forward("login", "index");
    }
  }
  /**
  *  extra pages
  */

  function extrapagesAction()
    {
      $this->view->setFile ("content", "register_author_extrapages.xml");
       //Create a new user and propose the form
      $paymentMode = new PaymentMode();
      $regChoice = new RegChoice();
      $regPage = new RegPage();
      $conferenceNames = new ConferenceNames();
      $conName_query = "SELECT id, name, abbr_name FROM ConferenceNames";
      $conName_result = $this->zmax_context->db->query ($conName_query);
      if ($conName_result === false){
        echo "Error";
      }
      else
      {
        $conname_options = "<select name='conf_acronym'>";
        while ($conName_r = $conName_result->fetch()){
          $conname_options = $conname_options."<option value=".$conName_r['abbr_name'].">".$conName_r['abbr_name']."</option></br>";
          $this->view->conference_name = $conName_r['abbr_name'];
        }
        $conname_options = $conname_options."</select>";
      }
      $this->view->conname_options = $conname_options;

      $payment_query = "SELECT id, mode FROM PaymentMode";
      $payment_result = $this->zmax_context->db->query ($payment_query);
      if ($payment_result === false){
        echo "Error";
      }
      else
      {
        $options_pay_mode = "";
        while ($payment_r = $payment_result->fetch())
        {
          if ($payment_r['id'] == 1)
          {
            $options_pay_mode = $options_pay_mode . "<input type='radio' name='payment_mode' value=".$payment_r['id']." checked='checked'>".$payment_r['mode']."</input></br>";
          }
          else
          {
            $options_pay_mode = $options_pay_mode . "<input type='radio' name='payment_mode' value=".$payment_r['id']." >".$payment_r['mode']."</input></br>";

          }
          //$this->view->options = "<option value='$payment_r['id']'>$payment_r['mode']</option>";
        }
      }
      $this->view->options_pay_mode = $options_pay_mode;

      $reg_fee_query="SELECT id_choice, choice, cost FROM RegChoice WHERE type='Author';";
      $reg_fee_result = $this->zmax_context->db->query ($reg_fee_query);
      if ($reg_fee_result === false){
        echo "Error";
      }
      else
      {
        $options_reg_fee = "";
        while ($reg_fee_r = $reg_fee_result->fetch())
        {
          if ($reg_fee_r['id_choice'] == '9')
          {
            $options_reg_fee = $options_reg_fee . "<input type='radio' name='author_reg_type' value=".$reg_fee_r['id_choice']." checked='checked'>".$reg_fee_r['choice']." ( ".$reg_fee_r['cost']." GBP )"."</input></br>";
          }
          //$this->view->options = "<option value='$payment_r['id']'>$payment_r['mode']</option>";
        }
      }
      $this->view->options_reg_fee=$options_reg_fee;

      $reg_page_query="SELECT id, type_name, price, notes FROM RegPage";
      $reg_page_result = $this->zmax_context->db->query ($reg_page_query);
      if ($reg_page_result === false){
        echo "Error";
      }
      else
      {
        $options_page_fee = "";
        while ($reg_page_r = $reg_page_result->fetch())
        {
          if ($reg_page_r['id'] == '1')
          {
            $options_page_fee = $options_page_fee . "<input type='radio' name='extra_pages_id' value=".$reg_page_r['id']." checked='checked'>".$reg_page_r['notes']." ( ".$reg_page_r['price']." GBP )"."</input></br>";
          }
          else
          {
            $options_page_fee = $options_page_fee . "<input type='radio' name='extra_pages_id' value=".$reg_page_r['id']." >".$reg_page_r['notes']." ( ".$reg_page_r['price']." GBP )"."</input></br>";

          }
          //$this->view->options = "<option value='$payment_r['id']'>$payment_r['mode']</option>";
        }
      }
      $this->view->options_page_fee=$options_page_fee;

      $reg_proceeding_query="SELECT name, price FROM RegOther WHERE id=1 ";
      $reg_proceeding_result = $this->zmax_context->db->query ($reg_proceeding_query);
      if ($reg_proceeding_result === false){
        echo "Error";
      }
      else
      {
        $options_proceeding_fee = "";
        while ($reg_proceeding_r = $reg_proceeding_result->fetch())
        {
            $options_proceeding_fee = "<input type='radio' name='extra_proceeding_num' value='1' />".'One '.$reg_proceeding_r['name']." ( ".$reg_proceeding_r['price']." GBP )"."</input></br>";
        }

      }
      $this->view->options_proceeding_fee=$options_proceeding_fee;
      $reg_dinner_query="SELECT name, price FROM RegOther WHERE id=2";
      $reg_dinner_result = $this->zmax_context->db->query ($reg_dinner_query);
      if ($reg_dinner_result === false){
        echo "Error";
      }
      else
      {
        while ($reg_dinner_r = $reg_dinner_result->fetch())
        {
            $this->view->form_dinner_fee = "( ". $reg_dinner_r['price']." GBP )";
        }

      }

      echo $this->view->render("layout");

    }

  /**
  *  author register
  */

  function authorregisterAction()
    {
      $this->view->setFile ("content", "register_author.xml");
       //Create a new user and propose the form
      $paymentMode = new PaymentMode();
      $regChoice = new RegChoice();
      $regPage = new RegPage();
      $conferenceNames = new ConferenceNames();
      $conName_query = "SELECT id, name, abbr_name FROM ConferenceNames";
      $conName_result = $this->zmax_context->db->query ($conName_query);
      if ($conName_result === false){
        echo "Error";
      }
      else
      {
        $conname_options = "<select name='conf_acronym'>";
        while ($conName_r = $conName_result->fetch()){
          $conname_options = $conname_options."<option value=".$conName_r['abbr_name'].">".$conName_r['abbr_name']."</option></br>";
          $this->view->conference_name = $conName_r['abbr_name'];
        }
        $conname_options = $conname_options."</select>";
      }
      $this->view->conname_options = $conname_options;

      $payment_query = "SELECT id, mode FROM PaymentMode";
      $payment_result = $this->zmax_context->db->query ($payment_query);
      if ($payment_result === false){
        echo "Error";
      }
      else
      {
        $options_pay_mode = "";
        while ($payment_r = $payment_result->fetch())
        {
          if ($payment_r['id'] == 1)
          {
            $options_pay_mode = $options_pay_mode . "<input type='radio' name='payment_mode' value=".$payment_r['id']." checked='checked'>".$payment_r['mode']."</input></br>";
          }
          else
          {
            $options_pay_mode = $options_pay_mode . "<input type='radio' name='payment_mode' value=".$payment_r['id']." >".$payment_r['mode']."</input></br>";

          }
          //$this->view->options = "<option value='$payment_r['id']'>$payment_r['mode']</option>";
        }
      }
      $this->view->options_pay_mode = $options_pay_mode;

      $reg_fee_query="SELECT id_choice, choice, cost FROM RegChoice WHERE type='Author';";
      $reg_fee_result = $this->zmax_context->db->query ($reg_fee_query);
      if ($reg_fee_result === false){
        echo "Error";
      }
      else
      {
        $options_reg_fee = "";
        while ($reg_fee_r = $reg_fee_result->fetch())
        {
          if ($reg_fee_r['choice'] == 'IEEE Member')
          {
            $options_reg_fee = $options_reg_fee . "<input type='radio' name='author_reg_type' value=".$reg_fee_r['id_choice']." checked='checked'>".$reg_fee_r['choice']." ( ".$reg_fee_r['cost']." GBP )"."</input></br>";
          }
          else
          {
            $options_reg_fee = $options_reg_fee . "<input type='radio' name='author_reg_type' value=".$reg_fee_r['id_choice']." >".$reg_fee_r['choice']." ( ".$reg_fee_r['cost']." GBP )"."</input></br>";

          }
          //$this->view->options = "<option value='$payment_r['id']'>$payment_r['mode']</option>";
        }
      }
      $this->view->options_reg_fee=$options_reg_fee;

      $reg_page_query="SELECT id, type_name, price, notes FROM RegPage";
      $reg_page_result = $this->zmax_context->db->query ($reg_page_query);
      if ($reg_page_result === false){
        echo "Error";
      }
      else
      {
        $options_page_fee = "";
        while ($reg_page_r = $reg_page_result->fetch())
        {
          if ($reg_page_r['id'] == '1')
          {
            $options_page_fee = $options_page_fee . "<input type='radio' name='extra_pages_id' value=".$reg_page_r['id']." checked='checked'>".$reg_page_r['notes']." ( ".$reg_page_r['price']." GBP )"."</input></br>";
          }
          else
          {
            $options_page_fee = $options_page_fee . "<input type='radio' name='extra_pages_id' value=".$reg_page_r['id']." >".$reg_page_r['notes']." ( ".$reg_page_r['price']." GBP )"."</input></br>";

          }
          //$this->view->options = "<option value='$payment_r['id']'>$payment_r['mode']</option>";
        }
      }
      $this->view->options_page_fee=$options_page_fee;

      $reg_proceeding_query="SELECT name, price FROM RegOther WHERE id=1 ";
      $reg_proceeding_result = $this->zmax_context->db->query ($reg_proceeding_query);
      if ($reg_proceeding_result === false){
        echo "Error";
      }
      else
      {
        $options_proceeding_fee = "";
        while ($reg_proceeding_r = $reg_proceeding_result->fetch())
        {
            $options_proceeding_fee = "<input type='radio' name='extra_proceeding_num' value='1' />".'One '.$reg_proceeding_r['name']." ( ".$reg_proceeding_r['price']." GBP )"."</input></br>";
        }

      }
      $this->view->options_proceeding_fee=$options_proceeding_fee;
      $reg_dinner_query="SELECT name, price FROM RegOther WHERE id=2";
      $reg_dinner_result = $this->zmax_context->db->query ($reg_dinner_query);
      if ($reg_dinner_result === false){
        echo "Error";
      }
      else
      {
        while ($reg_dinner_r = $reg_dinner_result->fetch())
        {
            $this->view->form_dinner_fee = "( ". $reg_dinner_r['price']." GBP )";
        }

      }

      echo $this->view->render("layout");

    }

    function banktransferAction()
    {
      $this->view->setFile ("content", "bank_transfer.xml");
      echo $this->view->render("layout");
    }

    /**
     * Add registered author
     */

    function addregauthorAction()
    {
      $regAuthor = new RegAuthor();
      $conf_acronym = $_POST['conf_acronym'];
      $paper_id = $_POST['paper_id'];
      $ieee_member_id = $_POST['ieee_member_id'];
      $author_title = $_POST['author_title'];
      $first_name = $_POST['first_name'];
      $last_name = $_POST['last_name'];
      $tag_name = $_POST['tag_name'];
      $affiliation = $_POST['affiliation'];
      $email = $_POST['email'];
      $phone = $_POST['phone'];
      $address = $_POST['address'];
      $city = $_POST['city'];
      $state= $_POST['state'];
      $country= $_POST['country'];
      $zip_code = $_POST['zip_code'];
      $payment_mode = $_POST['payment_mode'];
      $author_reg_type = $_POST['author_reg_type'];
      $extra_pages_id = $_POST['extra_pages_id'];
      $extra_proceeding_num = $_POST['extra_proceeding_num'];
      $extra_dinner_num = $_POST['extra_dinner_num'];
      $creation_date = date('Y-m-d H:i:s');

      $check_id = "SELECT * FROM PaperList WHERE paperID = '$paper_id' and conf_workshop_name = '$conf_acronym'";
      $result_ID = $this->zmax_context->db->query($check_id);
      $row_ID = $result_ID->fetch();

      $f_author_reg_type="";
      $f_author_reg_fee="";
      $f_extra_pages_id="";
      $f_extra_pages_fee="";
      $f_extra_proceeding_num="";
      $f_extra_proceeding_fee="";
      $f_extra_dinner_num= "";
      $f_extra_dinner_fee="";
      $f_total_price="";
      $f_payment_mode="";
      $pound=" GBP";
      if ($row_ID !=null)
      {
        $q_insert = "INSERT into RegAuthor (conf_acronym, paper_id, ieee_member_id, author_title, first_name,
        last_name, tag_name, affiliation, email, phone, address, city, state, country,zip_code,
        payment_mode, author_reg_type, extra_pages_id, extra_proceeding_id,extra_proceeding_num, extra_dinner_id, extra_dinner_num, paid,creation_date) values
        ('$conf_acronym', '$paper_id','$ieee_member_id','$author_title','$first_name', '$last_name','$tag_name','$affiliation','$email',
        '$phone','$address','$city','$state','$country','$zip_code','$payment_mode','$author_reg_type','$extra_pages_id',1,
        '$extra_proceeding_num',2,0,'N','$creation_date')";
        $result = $this->zmax_context->db->query($q_insert);
        if($result != null)
        {
          $q_id = "SELECT id FROM RegAuthor WHERE conf_acronym = '$conf_acronym' AND paper_id = '$paper_id' AND ieee_member_id='$ieee_member_id' AND
          author_title='$author_title' AND first_name='$first_name' AND last_name='$last_name' AND tag_name='$tag_name' AND affiliation='$affiliation' AND
          email='$email' AND phone='$phone' AND address='$address' AND city='$city' AND state='$state' AND country='$country' AND zip_code='$zip_code' AND
          payment_mode='$payment_mode' AND author_reg_type='$author_reg_type' AND extra_pages_id='$extra_pages_id' AND extra_proceeding_id =1 AND
          extra_proceeding_num='$extra_proceeding_num' AND extra_dinner_id=2 AND extra_dinner_num=0 AND paid='N' AND creation_date='$creation_date'";
          $q_id_result = $this->zmax_context->db->query ($q_id);
          while ($row = $q_id_result->fetch()){

            $payment_mode = "SELECT mode FROM PaymentMode WHERE id = $payment_mode";
            $payment_mode_row = $this->zmax_context->db->query ($payment_mode);
            if ($payment_mode_row!=null){
              while ($payment_row = $payment_mode_row->fetch())
              {
                $f_payment_mode= $payment_row['mode'];
              }
            }
            $author_type = "SELECT choice, cost FROM RegChoice WHERE id_choice = $author_reg_type and type='Author'";
            $author_type_row = $this->zmax_context->db->query ($author_type);
            if ($author_type_row != null){
              while ($type_row = $author_type_row->fetch())
              {
                $reg_price = $type_row['cost'];
                $f_author_reg_type=$type_row['choice'];
                $f_author_reg_fee=$type_row['cost'].$pound;

              }
            }
            $page_type = "SELECT type_name, price FROM RegPage WHERE id = $extra_pages_id";
            $page_type_row = $this->zmax_context->db->query ($page_type);
            if ($page_type_row != null){
              while ($page_row = $page_type_row->fetch()){
                $temp = $page_row['type_name'];
                $f_extra_pages_id = numtoword($temp);
                $page_price = $page_row['price'];
                $f_extra_pages_fee=$page_row['price'].$pound;

              }
            }
            $proceeding_type = "SELECT name, price FROM RegOther WHERE id = 1 ";
            $proceeding_type_row = $this->zmax_context->db->query ($proceeding_type);
            if ($proceeding_type_row != null){
              while ($proceeding_row = $proceeding_type_row->fetch()){
                $temp = $extra_proceeding_num;
                $f_extra_proceeding_num = numtoword($temp);
                $proceeding_price = (int)$proceeding_row['price'] * (int)$extra_proceeding_num;
                $f_extra_proceeding_fee = number_format((float)$proceeding_price,2,'.','').$pound;
              }
            }
            $dinner_type = "SELECT name, price FROM RegOther WHERE id = 2 ";
            $dinner_type_row = $this->zmax_context->db->query ($dinner_type);
            if ($dinner_type_row != null){
              while ($dinner_row = $dinner_type_row->fetch()){
                $temp = $extra_dinner_num;
                $f_extra_dinner_num =  numtoword($temp);
                $dinner_price = (int)$extra_dinner_num*(int)$dinner_row['price'];
                $f_extra_dinner_fee = number_format((float)$dinner_price,2,'.','').$pound;
              }
            }
            $total_price = intval($reg_price)+intval($page_price)+intval($proceeding_price)+intval($dinner_price);
            $f_total_price= number_format((float)$total_price,2,'.','').$pound;

            $mail = new Mail (Mail::SOME_USER, "Register Information", $this->view->getScriptPaths());
            $mail->setTo($email);
            $mail->setFormat(Mail::FORMAT_HTML);
            $mail->loadTemplate ($this->lang, "register_author_confirm");

            $mail->getEngine()->form_first_name = $first_name;
            $mail->getEngine()->form_last_name = $last_name;
            $mail->getEngine()->form_conf_acronym = $conf_acronym;
            $mail->getEngine()->form_paper_id = $conf_acronym."-".$paper_id;
            $mail->getEngine()->form_email = $email;
            $mail->getEngine()->form_affiliation = $affiliation;
            $mail->getEngine()->form_author_reg_type = $f_author_reg_type;
            $mail->getEngine()->form_author_reg_fee = $f_author_reg_fee;
            $mail->getEngine()->form_extra_pages_id = $f_extra_pages_id;
            $mail->getEngine()->form_extra_pages_fee = $f_extra_pages_fee;
            $mail->getEngine()->form_extra_proceeding_num = $f_extra_proceeding_num;
            $mail->getEngine()->form_extra_proceeding_fee = $f_extra_proceeding_fee;
            $mail->getEngine()->form_extra_dinner_num = $f_extra_dinner_num;
            $mail->getEngine()->form_extra_dinner_fee = $f_extra_dinner_fee;
            $mail->getEngine()->form_total_price = $f_total_price;
            $mail->getEngine()->form_payment_mode = $f_payment_mode;
            $mail->send();

	    $return_msg = $row['id'];
            //$this->_forward('regextrapages','index','',array('id'=> $row['id']));
          }
       }
      }
      else
      {
	$return_msg = -1;
        //echo "Error! Please enter the correct Paper-ID!";
      }
	echo json_encode($return_msg);
      
     
    }

    function participantregisterAction()
    {
      $this->view->setFile ("content", "register_participant.xml");
      $paymentMode = new PaymentMode();
      $regChoice = new RegChoice();
      $regPage = new RegPage();
      $conferenceNames = new ConferenceNames();
      $conName_query = "SELECT id, name, abbr_name FROM ConferenceNames;";
      $conName_result = $this->zmax_context->db->query ($conName_query);
      if ($conName_result === false){
        echo "Error";
      }
      else
      {
        $conname_options = "<select name='conf_acronym'>";
        while ($conName_r = $conName_result->fetch()){
          $conname_options = $conname_options."<option value=".$conName_r['abbr_name'].">".$conName_r['abbr_name']."</option></br>";
          $this->view->conference_name = $conName_r['abbr_name'];
        }
        $conname_options = $conname_options."</select>";
      }
      $this->view->conname_options = $conname_options;

      $payment_query = "SELECT id, mode FROM PaymentMode";
      $payment_result = $this->zmax_context->db->query ($payment_query);
      if ($payment_result === false){
        echo "Error";
      }
      else
      {
        $options_pay_mode = "";
        while ($payment_r = $payment_result->fetch())
        {
          if ($payment_r['id'] == 1)
          {
            $options_pay_mode = $options_pay_mode . "<input type='radio' name='payment_mode' value=".$payment_r['id']." checked='checked'>".$payment_r['mode']."</input></br>";
          }
          else
          {
            $options_pay_mode = $options_pay_mode . "<input type='radio' name='payment_mode' value=".$payment_r['id']." >".$payment_r['mode']."</input></br>";

          }
          //$this->view->options = "<option value='$payment_r['id']'>$payment_r['mode']</option>";
        }
      }
      $this->view->options_pay_mode = $options_pay_mode;

      $reg_fee_query="SELECT id_choice, choice, cost FROM RegChoice WHERE type='Participant'";
      $reg_fee_result = $this->zmax_context->db->query ($reg_fee_query);
      if ($reg_fee_result === false){
        echo "Error";
      }
      else
      {
        $options_reg_fee = "";
        while ($reg_fee_r = $reg_fee_result->fetch())
        {
          if ($reg_fee_r['choice'] == 'IEEE Member')
          {
            $options_reg_fee = $options_reg_fee . "<input type='radio' name='participant_reg_type' value=".$reg_fee_r['id_choice']." checked='checked'>".$reg_fee_r['choice']." ( ".$reg_fee_r['cost']." GBP )"."</input></br>";
          }
          else
          {
            $options_reg_fee = $options_reg_fee . "<input type='radio' name='participant_reg_type' value=".$reg_fee_r['id_choice']." >".$reg_fee_r['choice']." ( ".$reg_fee_r['cost']." GBP )"."</input></br>";

          }
          //$this->view->options = "<option value='$payment_r['id']'>$payment_r['mode']</option>";
        }
      }
      $this->view->options_reg_fee=$options_reg_fee;

      $reg_page_query="SELECT id, type_name, price, notes FROM RegPage";
      $reg_page_result = $this->zmax_context->db->query ($reg_page_query);
      if ($reg_page_result === false){
        echo "Error";
      }
      else
      {
        $options_page_fee = "";
        while ($reg_page_r = $reg_page_result->fetch())
        {
          if ($reg_page_r['id'] == '1')
          {
            $options_page_fee = $options_page_fee . "<input type='radio' name='extra_pages_id' value=".$reg_page_r['id']." checked='checked'>".$reg_page_r['notes']." ( ".$reg_page_r['price']." GBP )"."</input></br>";
          }
          else
          {
            $options_page_fee = $options_page_fee . "<input type='radio' name='extra_pages_id' value=".$reg_page_r['id']." >".$reg_page_r['notes']." ( ".$reg_page_r['price']." GBP )"."</input></br>";

          }
          //$this->view->options = "<option value='$payment_r['id']'>$payment_r['mode']</option>";
        }
      }
      $this->view->options_page_fee=$options_page_fee;

      $reg_proceeding_query="SELECT name, price FROM RegOther WHERE id=1 ";
      $reg_proceeding_result = $this->zmax_context->db->query ($reg_proceeding_query);
      if ($reg_proceeding_result === false){
        echo "Error";
      }
      else
      {
        $options_proceeding_fee = "";
        while ($reg_proceeding_r = $reg_proceeding_result->fetch())
        {
            $options_proceeding_fee = "<input type='radio' name='extra_proceeding_num' value='1' />".'One '.$reg_proceeding_r['name']." ( ".$reg_proceeding_r['price']." GBP )"."</input></br>";
        }

      }
      $this->view->options_proceeding_fee=$options_proceeding_fee;

      $reg_dinner_query="SELECT name, price FROM RegOther WHERE id=2";
      $reg_dinner_result = $this->zmax_context->db->query ($reg_dinner_query);
      if ($reg_dinner_result === false){
        echo "Error";
      }
      else
      {
        while ($reg_dinner_r = $reg_dinner_result->fetch())
        {
            $this->view->form_dinner_fee = "( ". $reg_dinner_r['price']." GBP )";
        }

      }
      echo $this->view->render("layout");
    }

    /**
     * Add registered author
     */

    function addregparticipantAction()
    {
      $regparticipant = new RegParticipant();
      $conf_acronym = $_POST['conf_acronym'];
      $ieee_member_id = $_POST['ieee_member_id'];
      $participant_title = $_POST['participant_title'];
      $first_name = $_POST['first_name'];
      $last_name = $_POST['last_name'];
      $tag_name = $_POST['tag_name'];
      $affiliation = $_POST['affiliation'];
      $email = $_POST['email'];
      $phone = $_POST['phone'];
      $address = $_POST['address'];
      $city = $_POST['city'];
      $state= $_POST['state'];
      $country= $_POST['country'];
      $zip_code = $_POST['zip_code'];
      $payment_mode = $_POST['payment_mode'];
      $participant_reg_type = $_POST['participant_reg_type'];
      $extra_proceeding_num = $_POST['extra_proceeding_num'];
      $extra_dinner_num = $_POST['extra_dinner_num'];
      $creation_date = date('Y-m-d H:i:s');
      $f_participant_reg_type="";
      $f_participant_reg_fee="";
      $f_extra_proceeding_num="";
      $f_extra_proceeding_fee="";
      $f_extra_dinner_num= "";
      $f_extra_dinner_fee="";
      $f_total_price="";
      $f_payment_mode="";
      $pound=" GBP";
      $q_insert = "INSERT into RegParticipant (conf_acronym, ieee_member_id, participant_title, first_name,
      last_name, tag_name, affiliation, email, phone, address, city, state, country,zip_code,
      payment_mode, participant_reg_type, extra_proceeding_id,extra_proceeding_num, extra_dinner_id, extra_dinner_num, paid,creation_date) values
      ('$conf_acronym','$ieee_member_id','$participant_title','$first_name', '$last_name','$tag_name','$affiliation','$email',
      '$phone','$address','$city','$state','$country','$zip_code','$payment_mode','$participant_reg_type',1,
      '$extra_proceeding_num',2,0,'N','$creation_date')";
      $result = $this->zmax_context->db->query($q_insert);
      if($result != null)
      {
        $q_id = "SELECT id FROM RegParticipant WHERE conf_acronym = '$conf_acronym' AND ieee_member_id='$ieee_member_id' AND
        participant_title='$participant_title' AND first_name='$first_name' AND last_name='$last_name' AND tag_name='$tag_name' AND affiliation='$affiliation' AND
        email='$email' AND phone='$phone' AND address='$address' AND city='$city' AND state='$state' AND country='$country' AND zip_code='$zip_code' AND
        payment_mode='$payment_mode' AND participant_reg_type='$participant_reg_type' AND extra_proceeding_id =1 AND
        extra_proceeding_num='$extra_proceeding_num' AND extra_dinner_id=2 AND extra_dinner_num=0 AND paid='N' AND creation_date='$creation_date'";
        $q_id_result = $this->zmax_context->db->query ($q_id);
        while ($row = $q_id_result->fetch()){
          $payment_mode = "SELECT mode FROM PaymentMode WHERE id = $payment_mode";
          $payment_mode_row = $this->zmax_context->db->query ($payment_mode);
          if ($payment_mode_row!=null){
            while ($payment_row = $payment_mode_row->fetch())
            {
              $f_payment_mode= $payment_row['mode'];
            }
          }
          $participant_type = "SELECT choice, cost FROM RegChoice WHERE id_choice = $participant_reg_type and type='Participant'";
          $participant_type_row = $this->zmax_context->db->query ($participant_type);
          if ($participant_type_row != null){
            while ($type_row = $participant_type_row->fetch())
            {
              $reg_price = $type_row['cost'];
              $f_participant_reg_type=$type_row['choice'];
              $f_participant_reg_fee= $type_row['cost'].$pound;
            }
          }
          $proceeding_type = "SELECT name, price FROM RegOther WHERE id = 1";
          $proceeding_type_row = $this->zmax_context->db->query ($proceeding_type);
          if ($proceeding_type_row != null){
            while ($proceeding_row = $proceeding_type_row->fetch()){
              $temp = $extra_proceeding_num;
              $f_extra_proceeding_num = numtoword($temp);
              $proceeding_price = (int)$proceeding_row['price'] * (int)$extra_proceeding_num;
              $f_extra_proceeding_fee = number_format((float)$proceeding_price,2,'.','').$pound;
            }
          }
          $dinner_type = "SELECT name, price FROM RegOther WHERE id = 2";
          $dinner_type_row = $this->zmax_context->db->query ($dinner_type);
          if ($dinner_type_row != null){
            while ($dinner_row = $dinner_type_row->fetch()){
              $temp = $extra_dinner_num;
              $f_extra_dinner_num =  numtoword($temp);
              $dinner_price = (int)$extra_dinner_num*(int)$dinner_row['price'];
              $f_extra_dinner_fee = number_format((float)$dinner_price,2,'.','').$pound;
            }
          }
          $total_price = intval($reg_price)+intval($proceeding_price)+intval($dinner_price);
          $this->view->form_total_price = number_format((float)$total_price,2,'.','');
          $f_total_price= number_format((float)$total_price,2,'.','').$pound;

          $mail = new Mail (Mail::SOME_USER, "Register confirmation", $this->view->getScriptPaths());
          $mail->setTo($email);
          $mail->setFormat(Mail::FORMAT_HTML);
          $mail->loadTemplate ($this->lang, "register_participant_confirm");
          $mail->getEngine()->form_first_name = $first_name;
          $mail->getEngine()->form_last_name = $last_name;
          $mail->getEngine()->form_conf_acronym = $conf_acronym;
          $mail->getEngine()->form_email = $email;
          $mail->getEngine()->form_affiliation = $affiliation;
          $mail->getEngine()->form_participant_reg_type = $f_participant_reg_type;
          $mail->getEngine()->form_participant_reg_fee = $f_participant_reg_fee;
          $mail->getEngine()->form_extra_proceeding_num = $f_extra_proceeding_num;
          $mail->getEngine()->form_extra_proceeding_fee = $f_extra_proceeding_fee;
          $mail->getEngine()->form_extra_dinner_num = $f_extra_dinner_num;
          $mail->getEngine()->form_extra_dinner_fee = $f_extra_dinner_fee;
          $mail->getEngine()->form_total_price = $f_total_price;
          $mail->getEngine()->form_payment_mode = $f_payment_mode;
          $mail->send();
          $this->_forward('regsumparticipant','index','',array('id'=> $row['id']));
        }
        //echo $q_id_result;
         //header("createaccount");
      }

    }

    function regsummaryAction()
    {
      $regPage = new RegPage();
      $regOther = new RegOther();
      $paymentMode = new PaymentMode();
      $regparticipant = new RegParticipant();
      $regPaperlist = new PaperList();
      $id = $this->_request->getParam('id');
      $this->view->form_register_id = $id;
      $q_result = "SELECT conf_acronym, paper_id, ieee_member_id, author_title, first_name,
      last_name, tag_name, affiliation, email, phone, address, city, state, country,zip_code,
      payment_mode, author_reg_type, extra_pages_id, extra_proceeding_id ,extra_proceeding_num, extra_dinner_id, extra_dinner_num FROM RegAuthor WHERE id ='$id'";
      $q_detail_result = $this->zmax_context->db->query ($q_result);
      $pound = " GBP";
      $reg_price = 0;
      $page_price = 0;
      $proceeding_price = 0;
      $dinner_price = 0;
      $f_first_name="";
      $f_last_name="";
      $f_conf_acronym="";
      $f_paper_id="";
      $f_email="";
      $f_affiliation="";
      $f_author_reg_type="";
      $f_author_reg_fee="";
      $f_extra_pages_id="";
      $f_extra_pages_fee="";
      $f_extra_proceeding_num="";
      $f_extra_proceeding_fee="";
      $f_extra_dinner_num="";
      $f_extra_dinner_fee="";
      $f_total_price="";
      $f_payment_mode="";
      if ($q_detail_result!=null)
      {
        while ($row = $q_detail_result->fetch()){
          $this->view->form_conf_acronym = $row['conf_acronym'];
          $this->view->form_paper_id = $row['conf_acronym']."-".$row['paper_id'];
          //$this->view->form_full_name = $row['first_name']." ".$row['last_name'];
          $this->view->form_first_name = $row['first_name'];
          $this->view->form_last_name = $row['last_name'];
          $this->view->form_preferred_name = $row['tag_name'];
          $this->view->form_affiliation = $row['affiliation'];
          $this->view->form_email = $row['email'];
          $this->view->form_phone = $row['phone'];
          //$this->view->form_address = $row['address'].", ".$row['city'].", ".$row['state'].", ".$row['country'].", ".$row['zip_code'];
          $this->view->form_address = $row['address'];
          $this->view->form_city = $row['city'];
          $this->view->form_state = $row['state'];
          $this->view->form_country = $row['country'];
          $this->view->form_zip_code = $row['zip_code'];

          $f_first_name=$row['first_name'];
          $f_last_name=$row['last_name'];
          $f_conf_acronym = $row['conf_acronym'];
          $f_paper_id = $row['conf_acronym']."-".$row['paper_id'];
          $f_email = $row['email'];
          $f_affiliation = $row['affiliation'];

          $payment_mode_id = (int)$row['payment_mode'];
          $this->view->payment_mode_id = $payment_mode_id;
          $payment_mode = "SELECT mode FROM PaymentMode WHERE id = $payment_mode_id";
          $payment_mode_row = $this->zmax_context->db->query ($payment_mode);
          if ($payment_mode_row!=null){
            while ($payment_row = $payment_mode_row->fetch())
            {
              $this->view->form_payment_mode = $payment_row['mode'];
              $f_payment_mode= $payment_row['mode'];
            }
          }
          $author_reg_type_id = (int)$row['author_reg_type'];
          //$this->view->form_author_reg_type = $author_reg_type_id;
          $author_type = "SELECT choice, cost FROM RegChoice WHERE id_choice = $author_reg_type_id and type='Author'";
          $author_type_row = $this->zmax_context->db->query ($author_type);
          if ($author_type_row != null){
            while ($type_row = $author_type_row->fetch())
            {
              $this->view->form_author_reg_type = $type_row['choice'];
              $this->view->form_author_reg_fee = $type_row['cost'].$pound;
              $reg_price = $type_row['cost'];
              $f_author_reg_type=$type_row['choice'];
              $f_author_reg_fee=$type_row['cost'].$pound;

            }
          }
          $extra_pages_id = $row['extra_pages_id'];
          $page_type = "SELECT type_name, price FROM RegPage WHERE id = $extra_pages_id";
          $page_type_row = $this->zmax_context->db->query ($page_type);
          if ($page_type_row != null){
            while ($page_row = $page_type_row->fetch()){

              $temp = $page_row['type_name'];
              $f_extra_pages_id = numtoword($temp);
              $this->view->form_extra_pages_id = $f_extra_pages_id;
              $this->view->form_extra_pages_fee = $page_row['price'].$pound;
              $page_price = $page_row['price'];
              $f_extra_pages_fee=$page_row['price'].$pound;

            }
          }
          $extra_proceeding_id = $row['extra_proceeding_id'];
          $proceeding_type = "SELECT name, price FROM RegOther WHERE id = $extra_proceeding_id ";
          $proceeding_type_row = $this->zmax_context->db->query ($proceeding_type);
          if ($proceeding_type_row != null){
            while ($proceeding_row = $proceeding_type_row->fetch()){
              $temp = $row['extra_proceeding_num'];
              $f_extra_proceeding_num = numtoword($temp);
              $this->view->form_extra_proceeding_num = $f_extra_proceeding_num;
              $proceeding_price = (int)$proceeding_row['price'] * (int)$row['extra_proceeding_num'];
              $this->view->form_extra_proceeding_fee = number_format((float)$proceeding_price,2,'.','').$pound;
              $f_extra_proceeding_fee = number_format((float)$proceeding_price,2,'.','').$pound;
            }
          }
          $extra_dinner_id = $row['extra_dinner_id'];
          $dinner_type = "SELECT name, price FROM RegOther WHERE id = $extra_dinner_id ";
          $dinner_type_row = $this->zmax_context->db->query ($dinner_type);
          if ($dinner_type_row != null){
            while ($dinner_row = $dinner_type_row->fetch()){
              $temp = $row['extra_dinner_num'];
              $f_extra_dinner_num =  numtoword($temp);
              $this->view->form_extra_dinner_num = $f_extra_dinner_num;
              $dinner_price = (int)$row['extra_dinner_num']*(int)$dinner_row['price'];
              $this->view->form_extra_dinner_fee = number_format((float)$dinner_price,2,'.','').$pound;
              $f_extra_dinner_fee = number_format((float)$dinner_price,2,'.','').$pound;
            }
          }
          $total_price = intval($reg_price)+intval($page_price)+intval($proceeding_price)+intval($dinner_price);
          $this->view->form_total_price = number_format((float)$total_price,2,'.','');
          $f_total_price= number_format((float)$total_price,2,'.','').$pound;
	
	  $re_conf_name= $row['conf_acronym'];
          $re_paper_ID = $row['paper_id'];
          $pay_result = "SELECT pay FROM PaperList WHERE conf_workshop_name = '$re_conf_name' and paperID = $re_paper_ID";
          $payMethod_row = $this->zmax_context->db->query ($pay_result);
	  if ($payMethod_row != null){
            while ($payMethod = $payMethod_row->fetch()){
		$re_pay_method = $payMethod['pay'];
	    }	    
          }
        }
      }
      else{
        echo "Error! Please try again!";
      }
      $payMethod = $re_pay_method;
      
     
      switch($payMethod){
	case "1":
      	$this->view->setFile ("content", "form_reg_author_result_uni1.xml");
	echo $this->view->render("layout");
        break;
	case "2":
	$this->view->setFile ("content","form_reg_author_result_uni2.xml");
	echo $this->view->render("layout");
	break;
	case "3":
        $this->view->setFile ("content","form_reg_author_result_paypal1.xml");
        echo $this->view->render("layout");
        break;
	case "4":
        $this->view->setFile ("content","form_reg_author_result_paypal2.xml");
        echo $this->view->render("layout");
        break;
	case "5":
        $this->view->setFile ("content","form_reg_author_result_paypal3.xml");
        echo $this->view->render("layout");
        break;
	case "6":
        $this->view->setFile ("content","form_reg_author_result_paypal_ZXY.xml");
        echo $this->view->render("layout");
        break;
     }
      
    }

    function regextrapagesAction()
    {
      $regPage = new RegPage();
      $regOther = new RegOther();
      $paymentMode = new PaymentMode();
      $regparticipant = new RegParticipant();
      $id = $this->_request->getParam('id');
      $this->view->form_register_id = $id;
      $q_result = "SELECT conf_acronym, paper_id, ieee_member_id, author_title, first_name,
      last_name, tag_name, affiliation, email, phone, address, city, state, country,zip_code,
      payment_mode, author_reg_type, extra_pages_id, extra_proceeding_id ,extra_proceeding_num, extra_dinner_id, extra_dinner_num FROM RegAuthor WHERE id ='$id'";
      $q_detail_result = $this->zmax_context->db->query ($q_result);
      $pound = " GBP";
      $reg_price = 0;
      $page_price = 0;
      $proceeding_price = 0;
      $dinner_price = 0;
      $f_first_name="";
      $f_last_name="";
      $f_conf_acronym="";
      $f_paper_id="";
      $f_email="";
      $f_affiliation="";
      $f_author_reg_type="";
      $f_author_reg_fee="";
      $f_extra_pages_id="";
      $f_extra_pages_fee="";
      $f_extra_proceeding_num="";
      $f_extra_proceeding_fee="";
      $f_extra_dinner_num="";
      $f_extra_dinner_fee="";
      $f_total_price="";
      $f_payment_mode="";
      if ($q_detail_result!=null)
      {
        while ($row = $q_detail_result->fetch()){
          $this->view->form_conf_acronym = $row['conf_acronym'];
          $this->view->form_paper_id = $row['conf_acronym']."-".$row['paper_id'];
          //$this->view->form_full_name = $row['first_name']." ".$row['last_name'];
          $this->view->form_first_name = $row['first_name'];
          $this->view->form_last_name = $row['last_name'];
          $this->view->form_preferred_name = $row['tag_name'];
          $this->view->form_affiliation = $row['affiliation'];
          $this->view->form_email = $row['email'];
          $this->view->form_phone = $row['phone'];
          //$this->view->form_address = $row['address'].", ".$row['city'].", ".$row['state'].", ".$row['country'].", ".$row['zip_code'];
          $this->view->form_address = $row['address'];
          $this->view->form_city = $row['city'];
          $this->view->form_state = $row['state'];
          $this->view->form_country = $row['country'];
          $this->view->form_zip_code = $row['zip_code'];

          $f_first_name=$row['first_name'];
          $f_last_name=$row['last_name'];
          $f_conf_acronym = $row['conf_acronym'];
          $f_paper_id = $row['conf_acronym']."-".$row['paper_id'];
          $f_email = $row['email'];
          $f_affiliation = $row['affiliation'];

          $payment_mode_id = (int)$row['payment_mode'];
          $this->view->payment_mode_id = $payment_mode_id;
          $payment_mode = "SELECT mode FROM PaymentMode WHERE id = $payment_mode_id";
          $payment_mode_row = $this->zmax_context->db->query ($payment_mode);
          if ($payment_mode_row!=null){
            while ($payment_row = $payment_mode_row->fetch())
            {
              $this->view->form_payment_mode = $payment_row['mode'];
              $f_payment_mode= $payment_row['mode'];
            }
          }
          $author_reg_type_id = (int)$row['author_reg_type'];
          //$this->view->form_author_reg_type = $author_reg_type_id;
          $author_type = "SELECT choice, cost FROM RegChoice WHERE id_choice = $author_reg_type_id and type='Author'";
          $author_type_row = $this->zmax_context->db->query ($author_type);
          if ($author_type_row != null){
            while ($type_row = $author_type_row->fetch())
            {
              $this->view->form_author_reg_type = $type_row['choice'];
              $this->view->form_author_reg_fee = $type_row['cost'].$pound;
              $reg_price = $type_row['cost'];
              $f_author_reg_type=$type_row['choice'];
              $f_author_reg_fee=$type_row['cost'].$pound;

            }
          }
          $extra_pages_id = $row['extra_pages_id'];
          $page_type = "SELECT type_name, price FROM RegPage WHERE id = $extra_pages_id";
          $page_type_row = $this->zmax_context->db->query ($page_type);
          if ($page_type_row != null){
            while ($page_row = $page_type_row->fetch()){

              $temp = $page_row['type_name'];
              $f_extra_pages_id = numtoword($temp);
              $this->view->form_extra_pages_id = $f_extra_pages_id;
              $this->view->form_extra_pages_fee = $page_row['price'].$pound;
              $page_price = $page_row['price'];
              $f_extra_pages_fee=$page_row['price'].$pound;

            }
          }
          $extra_proceeding_id = $row['extra_proceeding_id'];
          $proceeding_type = "SELECT name, price FROM RegOther WHERE id = $extra_proceeding_id ";
          $proceeding_type_row = $this->zmax_context->db->query ($proceeding_type);
          if ($proceeding_type_row != null){
            while ($proceeding_row = $proceeding_type_row->fetch()){
              $temp = $row['extra_proceeding_num'];
              $f_extra_proceeding_num = numtoword($temp);
              $this->view->form_extra_proceeding_num = $f_extra_proceeding_num;
              $proceeding_price = (int)$proceeding_row['price'] * (int)$row['extra_proceeding_num'];
              $this->view->form_extra_proceeding_fee = number_format((float)$proceeding_price,2,'.','').$pound;
              $f_extra_proceeding_fee = number_format((float)$proceeding_price,2,'.','').$pound;
            }
          }
          $extra_dinner_id = $row['extra_dinner_id'];
          $dinner_type = "SELECT name, price FROM RegOther WHERE id = $extra_dinner_id ";
          $dinner_type_row = $this->zmax_context->db->query ($dinner_type);
          if ($dinner_type_row != null){
            while ($dinner_row = $dinner_type_row->fetch()){
              $temp = $row['extra_dinner_num'];
              $f_extra_dinner_num =  numtoword($temp);
              $this->view->form_extra_dinner_num = $f_extra_dinner_num;
              $dinner_price = (int)$row['extra_dinner_num']*(int)$dinner_row['price'];
              $this->view->form_extra_dinner_fee = number_format((float)$dinner_price,2,'.','').$pound;
              $f_extra_dinner_fee = number_format((float)$dinner_price,2,'.','').$pound;
            }
          }
          $total_price = intval($reg_price)+intval($page_price)+intval($proceeding_price)+intval($dinner_price);
          $this->view->form_total_price = number_format((float)$total_price,2,'.','');
          $f_total_price= number_format((float)$total_price,2,'.','').$pound;
        }
      }
      else{
        echo "Error! Please try again!";
      }
      $this->view->setFile ("content", "form_reg_author_extrapages.xml");
      echo $this->view->render("layout");
    }

    function regsumparticipantAction()
    {
      $regPage = new RegPage();
      $regOther = new RegOther();
      $paymentMode = new PaymentMode();
      $id = $this->_request->getParam('id');
      $this->view->form_register_id = $id;
      $q_result = "SELECT conf_acronym, ieee_member_id, participant_title, first_name,
      last_name, tag_name, affiliation, email, phone, address, city, state, country,zip_code,
      payment_mode, participant_reg_type, extra_proceeding_id ,extra_proceeding_num, extra_dinner_id, extra_dinner_num FROM RegParticipant WHERE id ='$id'";
      $q_detail_result = $this->zmax_context->db->query ($q_result);
      $pound = " GBP";
      $reg_price = 0;
      $page_price = 0;
      $proceeding_price = 0;
      $dinner_price = 0;
      $f_first_name="";
      $f_last_name="";
      $f_conf_acronym="";
      $f_email="";
      $f_affiliation="";
      $f_participant_reg_type="";
      $f_participant_reg_fee="";
      $f_extra_proceeding_num="";
      $f_extra_proceeding_fee="";
      $f_extra_dinner_num="";
      $f_extra_dinner_fee="";
      $f_total_price="";
      $f_payment_mode="";
      if ($q_detail_result!=null)
      {
        while ($row = $q_detail_result->fetch()){
          $this->view->form_conf_acronym = $row['conf_acronym'];
          //$this->view->form_full_name = $row['first_name']." ".$row['last_name'];
          $this->view->form_first_name = $row['first_name'];
          $this->view->form_last_name = $row['last_name'];
          $this->view->form_preferred_name = $row['tag_name'];
          $this->view->form_affiliation = $row['affiliation'];
          $this->view->form_email = $row['email'];
          $this->view->form_phone = $row['phone'];
          //$this->view->form_address = $row['address'].", ".$row['city'].", ".$row['state'].", ".$row['country'].", ".$row['zip_code'];
          $this->view->form_address = $row['address'];
          $this->view->form_city = $row['city'];
          $this->view->form_state = $row['state'];
          $this->view->form_country = $row['country'];
          $this->view->form_zip_code = $row['zip_code'];

          $f_first_name=$row['first_name'];
          $f_last_name=$row['last_name'];
          $f_conf_acronym = $row['conf_acronym'];
          $f_email = $row['email'];
          $f_affiliation = $row['affiliation'];

          $payment_mode_id = (int)$row['payment_mode'];
          $this->view->payment_mode_id = $payment_mode_id;
          $payment_mode = "SELECT mode FROM PaymentMode WHERE id = $payment_mode_id";
          $payment_mode_row = $this->zmax_context->db->query ($payment_mode);
          if ($payment_mode_row!=null){
            while ($payment_row = $payment_mode_row->fetch())
            {
              $this->view->form_payment_mode = $payment_row['mode'];
              $f_payment_mode= $payment_row['mode'];
            }
          }
          $participant_reg_type_id = (int)$row['participant_reg_type'];
          //$this->view->form_author_reg_type = $author_reg_type_id;
          $participant_type = "SELECT choice, cost FROM RegChoice WHERE id_choice = $participant_reg_type_id and type='Participant'";
          $participant_type_row = $this->zmax_context->db->query ($participant_type);
          if ($participant_type_row != null){
            while ($type_row = $participant_type_row->fetch())
            {
              $this->view->form_participant_reg_type = $type_row['choice'];
              $this->view->form_participant_reg_fee = $type_row['cost'].$pound;
              $reg_price = $type_row['cost'];
              $f_participant_reg_type=$type_row['choice'];
              $f_participant_reg_fee=$type_row['cost'].$pound;
            }
          }

          $extra_proceeding_id = $row['extra_proceeding_id'];
          $proceeding_type = "SELECT name, price FROM RegOther WHERE id = $extra_proceeding_id ";
          $proceeding_type_row = $this->zmax_context->db->query ($proceeding_type);
          if ($proceeding_type_row != null){
            while ($proceeding_row = $proceeding_type_row->fetch()){
              $temp = $row['extra_proceeding_num'];
              $f_extra_proceeding_num = numtoword($temp);
              $this->view->form_extra_proceeding_num = $f_extra_proceeding_num;
              $proceeding_price = (int)$proceeding_row['price'] * (int)$row['extra_proceeding_num'];
              $this->view->form_extra_proceeding_fee = number_format((float)$proceeding_price,2,'.','').$pound;
              $f_extra_proceeding_fee = number_format((float)$proceeding_price,2,'.','').$pound;
            }
          }
          $extra_dinner_id = $row['extra_dinner_id'];
          $dinner_type = "SELECT name, price FROM RegOther WHERE id = $extra_dinner_id ";
          $dinner_type_row = $this->zmax_context->db->query ($dinner_type);
          if ($dinner_type_row != null){
            while ($dinner_row = $dinner_type_row->fetch()){
              $temp = $row['extra_dinner_num'];
              $f_extra_dinner_num =  numtoword($temp);
              $this->view->form_extra_dinner_num = $f_extra_dinner_num;
              $dinner_price = (int)$row['extra_dinner_num']*(int)$dinner_row['price'];
              $this->view->form_extra_dinner_fee = number_format((float)$dinner_price,2,'.','').$pound;
              $f_extra_dinner_fee = number_format((float)$dinner_price,2,'.','').$pound;
            }
          }
          $total_price = intval($reg_price)+intval($proceeding_price)+intval($dinner_price);
          $this->view->form_total_price = number_format((float)$total_price,2,'.','');
          $f_total_price= number_format((float)$total_price,2,'.','').$pound;
        }

      }
      else{
        echo "Error! Please try again!";
      }
      $this->view->setFile ("content", "form_reg_participant_result_paypal1.xml");
      echo $this->view->render("layout");
    }

    function cancelpaymentAction()
    {
      $regAuthor = new RegAuthor();
      $register_id = $_GET['reg_id'];
      $user_info = "SELECT * FROM RegAuthor WHERE id = $register_id";
      $user_info_result = $this->zmax_context->db->query ($user_info);
      while ($user_info_row = $user_info_result->fetch()){
        $user_mail = $user_info_row['email'];
        $user_firstname = $user_info_row['first_name'];
        $user_lastname = $user_info_row['last_name'];
        $this->_forward('regSummary','index','',array('id'=> $register_id));
      }
      $mail = new Mail (Mail::SOME_USER, "Payment cancelled", $this->view->getScriptPaths());
      $mail->setTo($user_mail);
      $mail->setFormat(Mail::FORMAT_HTML);
      $mail->loadTemplate ($this->lang, "payment_cancel");
      $mail->getEngine()->info_email = $user_mail;
      $mail->getEngine()->info_first_name = $user_firstname;
      $mail->getEngine()->info_last_name = $user_lastname;
      $mail->send();
    }

    function cancelpaymentpartiAction()
    {
      $regAuthor = new RegParticipant();
      $register_id = $_GET['reg_id'];
      $user_info = "SELECT * FROM RegParticipant WHERE id = $register_id";
      $user_info_result = $this->zmax_context->db->query ($user_info);
      while ($user_info_row = $user_info_result->fetch()){
        $user_mail = $user_info_row['email'];
        $user_firstname = $user_info_row['first_name'];
        $user_lastname = $user_info_row['last_name'];
        $this->_forward('regsumparticipant','index','',array('id'=> $register_id));
      }
      $mail = new Mail (Mail::SOME_USER, "Payment cancelled", $this->view->getScriptPaths());
      $mail->setTo($user_mail);
      $mail->setFormat(Mail::FORMAT_HTML);
      $mail->loadTemplate ($this->lang, "payment_cancel");
      $mail->getEngine()->info_email = $user_mail;
      $mail->getEngine()->info_first_name = $user_firstname;
      $mail->getEngine()->info_last_name = $user_lastname;
      $mail->send();
    }

    function updatepaymentAction()
    {
      $regAuthor = new RegAuthor();
      $register_id = $_GET['reg_id'];
      $update_payment = "UPDATE RegAuthor SET paid = 'Y' WHERE id = $register_id ";
      $update_result = $this->zmax_context->db->query($update_payment);
      $user_mail="zy246@exeter.ac.uk";
      $user_firstname ="";
      $user_lastname ="";
      $conf="";
      $paper_id="";

      if ($update_result != null){

        $user_info = "SELECT * FROM RegAuthor WHERE paid = 'Y' AND id = $register_id" ;
        $user_info_result = $this->zmax_context->db->query ($user_info);
        while ($user_info_row = $user_info_result->fetch()){
          $conf = $user_info_row['conf_acronym'];
          $paper_id = $user_info_row['paper_id'];
          $paper_id = $conf."-".$paper_id;
          $user_mail = $user_info_row['email'];
          $user_firstname = $user_info_row['first_name'];
          $user_lastname = $user_info_row['last_name'];
        }
        $mail = new Mail (Mail::SOME_USER, "Payment confirmation", $this->view->getScriptPaths());
        $mail->setTo($user_mail);
        $mail->setFormat(Mail::FORMAT_HTML);
        $mail->loadTemplate ($this->lang, "payment_confirm");
        $mail->getEngine()->info_email = $user_mail;
        $mail->getEngine()->info_first_name = $user_firstname;
        $mail->getEngine()->info_last_name = $user_lastname;
        $mail->send();
        $this->view->form_first_name = $user_firstname;
        $this->view->form_last_name = $user_lastname;
        $this->view->form_email = $user_mail;
        $this->view->form_paper_id = $paper_id;
        $this->view->form_conf_acronym = $conf;
        $this->view->setFile ("content", "payment_success.xml");
        echo $this->view->render("layout");
      }
      else{
        echo "Error";
      }
    }

    function updatepaymentpartiAction()
    {
      $regparticipant = new RegParticipant();
      $register_id = $_GET['reg_id'];
      $update_payment = "UPDATE RegParticipant SET paid = 'Y' WHERE id = $register_id ";
      $update_result = $this->zmax_context->db->query ($update_payment);
      $user_mail="zy246@exeter.ac.uk";
      $user_firstname ="";
      $user_lastname ="";
      $conf="";

      if ($update_result != null){

        $user_info = "SELECT * FROM RegParticipant WHERE paid = 'Y' AND id = $register_id" ;
        $user_info_result = $this->zmax_context->db->query ($user_info);
        while ($user_info_row = $user_info_result->fetch()){
          $conf = $user_info_row['conf_acronym'];
          $user_mail = $user_info_row['email'];
          $user_firstname = $user_info_row['first_name'];
          $user_lastname = $user_info_row['last_name'];
        }
        $mail = new Mail (Mail::SOME_USER, "Payment confirmation", $this->view->getScriptPaths());
        $mail->setTo($user_mail);
        $mail->setFormat(Mail::FORMAT_HTML);
        $mail->loadTemplate ($this->lang, "payment_confirm");
        $mail->getEngine()->info_email = $user_mail;
        $mail->getEngine()->info_first_name = $user_firstname;
        $mail->getEngine()->info_last_name = $user_lastname;
        $mail->send();
        $this->view->form_first_name = $user_firstname;
        $this->view->form_last_name = $user_lastname;
        $this->view->form_email = $user_mail;
        $this->view->form_conf_acronym = $conf;
        $this->view->setFile ("content", "payment_success_parti.xml");
        echo $this->view->render("layout");
      }
      else{
        echo "Error";
      }
    }


  /**
   * Register to the conference
   * @author philipperigaux
   *
   */

  function registerAction()
  {
    $this->view->setFile ("content", "register.xml");
    // Create a new user and propose the form
    $user  = new User();
    $userRow = $user->createRow();
    $this->view->form_user =    $userRow->form($this->view, "form_user.xml", true, true);

    $this->view->form_mode = "insert";

    echo $this->view->render("layout");
  }

  /**
   * Show the program of the conference
   */

  function programAction()
  {
    $confSessionTbl = new ConfSession();

    $this->view->setFile("content","program.xml");
    $this->view->set_block ("content", "DATE", "DATES");
    $this->view->set_block ("DATE", "SESSION_DETAIL", "SESSIONS");
    $this->view->set_block ("SESSION_DETAIL", "PAPER_DETAIL", "PAPERS");
    $this->view->set_block ("SESSION_DETAIL", "PAPER_DOWNLOAD", " ");
    $this->view->set_block ("SESSION_DETAIL", "CHAIR", "SHOW_CHAIR");
    $this->view->set_block ("SESSION_DETAIL", "ROOM", "SHOW_ROOM");

    // Check whether the links to CR files are required
    $listFiles = array();
    if (isSet($_REQUEST['with_links'])) {
      // Get the list of required files in the proceedings phase
      $requiredFileTbl = new RequiredFile();
      $requiredFiles = $requiredFileTbl->fetchAll("id_phase = " . Config::PROCEEDINGS_PHASE);
      foreach ($requiredFiles as $requiredFile) {
        $listFiles[$requiredFile->file_code] = $requiredFile->file_extension;
      }

      // Directory of the CR files: the "proceedings" subdirectory must
      // be copied under the current directory when the program is published.
      $fileDir =  $this->zmax_context->config->app->upload_path . DIRECTORY_SEPARATOR ;
    }
    else {
      $this->view->download_link = "";
    }

    // First, loop on the dates
    $q_dates = "SELECT DISTINCT slot_date, UNIX_TIMESTAMP(slot_date) AS timestamp FROM Slot s ORDER BY slot_date";
    $rDates = $this->zmax_context->db->query ($q_dates);
    while ($date =  $rDates->fetch (Zend_Db::FETCH_OBJ)) {
      $this->view->SESSIONS = "";
      $zDate = new Zend_Date ($date->timestamp, Zend_Date::TIMESTAMP);
      $this->view->date = $zDate->toString("EEEE d MMM yyyy", $this->zmax_context->locale);

      $q_sessions = "SELECT c.id, name, chair, comment as sess_comment, room, "
      . " end as slot_end, begin as slot_begin "
      . " FROM ConfSession c, Slot s "
      . " WHERE s.id=c.id_slot AND slot_date='$date->slot_date'"
      . " ORDER BY slot_date, begin, end, c.id";
      $rSess = $this->zmax_context->db->query ($q_sessions);
      while ($session =  $rSess->fetch (Zend_Db::FETCH_OBJ)) {
        $this->view->PAPERS = "";
        $this->view->conf_session_name = $session->name;
        $this->view->conf_slot_name = substr($session->slot_begin,0,5) . "-" .
        substr($session->slot_end, 0, 5);
        $this->view->conf_session_comment = $session->sess_comment;
        $this->view->conf_session_chair = $session->chair;
        $this->view->conf_session_room = $session->room;

        if (empty ($session->room)) {
          $this->view->SHOW_ROOM = "";
        }
        else {
          $this->view->assign("SHOW_ROOM", "ROOM");
        }
        if (empty ($session->chair)) {
          $this->view->SHOW_CHAIR = "";
        }
        else {
          $this->view->assign("SHOW_CHAIR", "CHAIR");
        }

        // Now, loop on accepter papers
        $q_papers = "SELECT * FROM Paper "
        . "WHERE id_conf_session='$session->id' ORDER BY position_in_session";
        $rp = $this->zmax_context->db->query ($q_papers);
        while ($paper =  $rp->fetch (Zend_Db::FETCH_OBJ)) {
          $this->view->paper_authors =  PaperRow::getPaperAuthors($this->zmax_context->db, $paper);

          $this->view->paper_title = $paper->title ;

          // Take the name of the camera ready file
          foreach ($listFiles as $code => $ext) {
            $filePath =  "." . DIRECTORY_SEPARATOR . "proceedings" . DIRECTORY_SEPARATOR . $code . "_" . $paper->id . "." . $ext;
            if (file_exists($filePath)) {
              $this->view->file_path = $filePath;
              // $this->texts->author->get($code) . "</a>";
              $this->view->append("PAPERS", "PAPER_DOWNLOAD");
            }
            else {
              // No file to download
              $this->view->append("PAPERS", "PAPER_DETAIL");
            }
          }
        }
        $this->view->append("SESSIONS", "SESSION_DETAIL");
      }
      $this->view->append("DATES", "DATE");
    }
    echo $this->view->render("layout");
  }

  /**
   * Send an email to the user along with the password
   *
   */
  function passwordrecallAction ()
  {
    // There should be an email param
    $email = $this->getRequest()->getParam('email');

    if (empty($email)) {
      $this->_forward ("lostpassword", "index");
    }
    else {
      // We must send the password to the user
      $user = new User();
      $userRow = $user->findByEmail ($email);

      if (is_object($userRow)) {
        // Get the default password, and assign it to the user
        $password = $userRow->defaultPassword($this->config_v1["passwordGenerator"]);

        $userRow->password = md5($password);
        $userRow->save();

        $userRow->putInView($this->view);

        // And, finally: send a message to the chair, and show a polite ack.
        $mail = new Mail (Mail::SOME_USER, $this->texts->mail->subj_password_recall,
        $this->view->getScriptPaths());
        $mail->setFormat(Mail::FORMAT_HTML);
        $mail->loadTemplate ($this->lang, "send_password");
        $mail->setTo($userRow->email);
        $mail->getEngine()->password = $password;
        $mail->send();
      }

      $this->view->setFile ("content", "passwordrecall.xml");

      echo $this->view->render("layout");
    }
  }

  /**
   * Check whether an account already exists
   */
  function checkaccountAction()
  {
    // Check whther there is  an email param
    $email = $this->getRequest()->getParam('email');

    if (empty($email)) {
      $this->view->setFile ("content", "checkaccount.xml");
    }
    else {
      // We send an ack. to the user
      $user = new User();
      $userRow = $user->findByEmail ($email);

      if (is_object($userRow)) {
        // Send a message to the user
        $mail = new Mail (Mail::SOME_USER, $this->texts->mail->subj_check_account,
        $this->view->getScriptPaths());
        $mail->loadTemplate ($this->lang, "ack_account");
        $mail->setFormat(Mail::FORMAT_HTML);
        $mail->setTo($userRow->email);
        $mail->send();
      }
      $this->view->setFile ("content", "ack_account.xml");
    }
    echo $this->view->render("layout");
  }

  /*
   * Sho the login form
   */

  function loginAction ()
  {
    $request = $this->getRequest();
    $email = strToLower($request->getParam("email"));
    $password = $request->getParam("password");

    // Protect the input data
    $email = stripSlashes ($email);
    $password = stripSlashes ($password);

    $template = "login.xml";
    $idSession = session_id();

    $texts = $this->zmax_context->texts;

    // Check whether we arrive here from a denied access to a requested URL
    $requestedUrl = $request->getParam("requestedUrl") ;
    if (empty($requestedUrl)) $requestedUrl = $this->myUrl();

    // Put some info in the view
    $this->view->requestedUrl = $requestedUrl;
    $this->view->email = $email;
    $this->view->login_message = "";

    // Get the current session (if any)
    $sessionTbl = new Session();
    $currentSession = $sessionTbl->find($idSession)->current();

    // Session found?
    if (is_object($currentSession)) {
      // is it valid ?
      if ($currentSession->isValid()) {
        // Reinitialize the validity period
        $currentSession->tempsLimite = date ("U") + 7200;
        $currentSession->save();
        // And confirm the connection
        $template = "already_logged_in.xml";
      }
      else {
        $template = "login.xml";
        $this->view->login_message =  $texts->def->session_no_longer_valid;
      }
    }
    // Cas 2.a: pas de session mais email et mot de passe

    if (!empty($email)) {

      if ($sessionTbl->create ($email, $password, $idSession)) {
        // Connection OK. Forward to the a page, depending on the role
        $this->getRequest()->setParam("login_successful", 1);
        $userTbl = new User();
        $user = $userTbl->findByEmail($email);
        if ($user->isAdmin()) {
          $this->_forward("index", "chair", "admin");
        }
        else if ($user->isReviewer()) {
          $this->_forward("index", "reviewer");
        }
        else {
          $this->_forward("guidelines", "index");
        }

        return;
      }
      else {
        // echo "Login failed<br/>";
        $template = "login.xml";
        $this->view->login_message =  $texts->def->login_failed;
      }
    }

    $this->view->setFile("content", $template);
    echo $this->view->render("layout");
  }

  /**
   * Logout action: delete the current session
   *
   */
  public function logoutAction()
  {
    // Delete the current session
    $q = "DELETE FROM Session WHERE idSession='" . session_id() . "'";
    $this->zmax_context->db->query($q);

    // Forward to the "index" action of the current module
    $req = $this->getRequest();
    $this->_forward("index", "index", $req->getModuleName());
  }

  /*
   * Action launched when an access is denied
   */
  function accessdeniedAction()
  {
    $this->view->content = $this->zmax_context->texts->access_denied;
    echo $this->view->render("layout");
  }

  /*
   * A reviewer declines an invitation to participate
   */
  function declineAction()
  {
    // Check that this is the true reviewer
    $email = $this->getRequest()->getParam("email");
    $password = $this->getRequest()->getParam("password");
    $idSession = session_id();

    // Delete the curent session if any
    $this->deleteCurrentSession();

    // Now, try to open a session with the email and password
    $sessionTbl = new Session();
    // if (!$sessionTbl->create ($email, $password, $idSession)) {
    //   // No way to open a session? Something wrong: redirect to the home page.
    //   $redirect = $this->view->base_url . "/";
    //   $this->_redirect($redirect);;
    // }

    // Get the user and remove the 'reviewer' role
    $user = new User();
    $userRow = $user->findByEmail($email);
    $this->user = $userRow;
    $userRow->removeRole(User::REVIEWER_ROLE);
    $userRow->save();

    // Put the user and the config in the view
    $userRow->putInView($this->view);

    // And, finally: send a message to the chair, and show a polite ack.
    $mail = new Mail (Mail::PC_CHAIR, $this->texts->mail->subj_decline_invitation,
    $this->view->getScriptPaths());
    $mail->setFormat(Mail::FORMAT_HTML);
    $mail->loadTemplate ($this->lang, "decline_invitation");
    $mail->getEngine()->invited_user =  $this->user->fullName();
    $mail->send();

    $this->view->setFile("content", "decline.xml");
    echo $this->view->render("layout");
  }

  /*
   * A reviewer accepts an invitation to participate
   */
  function acceptAction()
  {
    // Check that this is the true reviewer
    $email = $this->getRequest()->getParam("email");
    $password = $this->getRequest()->getParam("password");
    $idSession = session_id();

    // Delete the curent session if any
    $this->deleteCurrentSession();

    // Get the user, mark as "confirmed", and show some instructions
    $user = new User();
    $this->user= $user->findByEmail($email);

    // User not found? Probably an attempt to enter the system without auth.
    if (!is_object($this->user)) {
      $this->_redirect($this->view->base_url . "/");
    }

    // Set the default password
    $this->user->invitation_confirmed = 'Y';
    $password = $this->user->defaultPassword($this->config->passwordGenerator);
    $this->user->password = md5($password);
    $this->user->save();
    $this->user->putInView($this->view);

    // Send a message to the chair
    $mail = new Mail (Mail::PC_CHAIR, $this->texts->mail->subj_accept_invitation,
    $this->view->getScriptPaths());
    $mail->setFormat(Mail::FORMAT_HTML);
    $mail->loadTemplate ($this->lang, "accept_invitation");
    $mail->getEngine()->invited_user =  $this->user->fullName();
    $mail->send();

    // Send a message to the user with instructions
    $mail->setTo($email);
    $mail->loadTemplate ($this->lang, "reviewer_instructions");
    $this->config->putInView($mail->getEngine());
    $mail->getEngine()->password = $password;
    $mail->send();

    $this->view->setFile("content", "accept.xml");
    echo $this->view->render("layout");
  }

  /**
   * Utility function that deletes the current session
   */
  private function deleteCurrentSession()
  {
    $idSession = session_id();
    $sessionTbl = new Session();
    $currentSession = $sessionTbl->find($idSession)->current();

    // Session found? Delete it
    if (is_object($currentSession)) {
      $q = "DELETE FROM Session WHERE idSession='$idSession'";
      $this->zmax_context->db->query($q);
    }

  }
}
